/**
 * Copyright Notice
 *
 * This is a work of the U.S. Government and is not subject to copyright
 * protection in the United States. Foreign copyrights may apply.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package gov.vha.vuid.rest.session;

import java.net.URL;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import gov.vha.isaac.ochre.api.LookupService;
import gov.vha.vuid.rest.ApplicationConfig;

/**
 * 
 * {@link PrismeServiceUtils}
 *
 * @author <a href="mailto:joel.kniaz.list@gmail.com">Joel Kniaz</a>
 *
 */
public class PrismeServiceUtils {

	private PrismeServiceUtils() {}
	
	protected static String getConfigProperty(String propertyName)
	{
		switch(propertyName)
		{
			//https://DNS              :PORT
			case "prisme_roles_by_token_url" :
				return "https://" + ApplicationConfig.getInstance().getHostname() + ":" + ApplicationConfig.getInstance().getPort() 
						+ "/rails_prisme/roles/get_roles_by_token.json";
			default:
				throw new RuntimeException("Unknown property Name '" + propertyName + "'");
		}
	}
	
	
	public static String getTargetFromUrl(URL url) {
		StringBuilder target = new StringBuilder();
		target.append(url.getProtocol());
		target.append("://");
		target.append(url.getHost());
		if (url.getPort() > 0) {
			target.append(":" + url.getPort());
		}
		
		return target.toString();
	}

	static String postJsonToPrisme(WebTarget targetWithPath, String json, Map<String, String> params) {
		if (params != null) {
			for (Map.Entry<String, String> entry : params.entrySet()) {
				targetWithPath = targetWithPath.queryParam(entry.getKey(), entry.getValue());
			}
		}
		Response response = targetWithPath.request().post(Entity.json(json));
		
		String responseJson = response.readEntity(String.class);
	
		return responseJson;
	}

	static String getResultJsonFromPrisme(WebTarget targetWithPath, Map<String, String> params) {
		for (Map.Entry<String, String> entry : params.entrySet()) {
			targetWithPath = targetWithPath.queryParam(entry.getKey(), entry.getValue());
		}
		
		Response response = targetWithPath.request().get();
		
		String responseJson = response.readEntity(String.class);
	
		return responseJson;
	}
	
	static String getResultJsonFromPrisme(String targetStr, String pathStr, Map<String, String> params) {
		ClientService clientService = LookupService.getService(ClientService.class);
		WebTarget target = clientService.getClient().target(targetStr);
		target = target.path(pathStr);
		
		return getResultJsonFromPrisme(target, params);
	}
}
